"use strict";

(function () {
    let app = angular.module('workstationSchedule', []);
    app.directive('workstationSchedule', function () {
        return {
            restrict: 'E',
            templateUrl: 'templates/workstation/schedule.html',
            controller: function ($rootScope, $scope) {
                let ctrl = this;
                $scope.GetLocalized = Helpers.GetLocalized;
                let workingHours = $rootScope.selectedWorkstation.employee.workingHours;

                let hours = ["12am", "1am", "2am", "3am", "4am", "5am", "6am", "7am", "8am", "9am", "10am", "11am", "12pm",
                    "1pm", "2pm", "3pm", "4pm", "5pm", "6pm", "7pm", "8pm", "9pm", "10pm", "11pm", "12am"];

                let loadValues = () => {
                    ctrl.totalHours = Helpers.CalculateTotalWorkHours(workingHours);
                    ctrl.exhaustion = Helpers.CalculateHourlyExhaustion($rootScope.selectedWorkstation.employee);
                    ctrl.exhaustion.total *= ctrl.totalHours;
                    ctrl.exhaustion.base *= ctrl.totalHours;
                };

                loadValues();

                $scope.slider = {
                    value: 1,
                    minValue: moment(workingHours.start.hour,["H"]).format('ha'),
                    maxValue: moment(workingHours.end.hour,["H"]).format('ha'),
                    options: {
                        stepsArray: hours,
                        floor: 0,
                        ceil: 24,
                        step: 1,
                        minRange: 3,
                        maxRange: 24,
                        pushRange: true,
                        noSwitching: true,
                        disabled: !$scope.$parent.ctrl.hasEmployeeHrManager,
                        onChange: () => {
                            workingHours.start.hour = moment($scope.slider.minValue,["hA"]).hours();
                            workingHours.end.hour = moment($scope.slider.maxValue,["hA"]).hours();
                            workingHours.start.minute = 0;
                            workingHours.end.minute = 0;
                            loadValues();
                        }
                    }
                };
            },
            controllerAs: 'ctrl'
        }
    });

})();